<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

$objectManager = Bootstrap::getObjectManager();

/** @var PostRepositoryInterface $postRepository */
$postRepository = $objectManager->create(PostRepositoryInterface::class);

$postUrl = ['post-test-one-graph-ql', 'post-test-two-graph-ql', 'post-test-three-graph-ql'];
$posts = $postRepository->getPostCollection()->getItems();

foreach ($posts as $post) {
    if (in_array($post->getDataByKey('url_key'), $postUrl)) {
        $postRepository->deleteById((int)$post->getDataByKey('post_id'));
    }
}

Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/blog_authors_rollback.php');
Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/blog_category_rollback.php');
Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/blog_tags_rollback.php');
