<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\CommentRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Magento/Customer/_files/new_customer_rollback.php');
Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/posts_rollback.php');

$objectManager = Bootstrap::getObjectManager();

/** @var CommentRepositoryInterface $commentRepository */
$commentRepository = $objectManager->create(CommentRepositoryInterface::class);

$comments = $commentRepository->getCollection()->getItems();
$commentsEmail = [
    'new_customer@example.com',
    'graph_one@example.com',
    'graph_reply@example.com',
    'graph_two@example.com'
];

foreach ($comments as $comment) {
    if (in_array($comment->getDataByKey('email'), $commentsEmail)) {
        $commentRepository->deleteById((int)$comment->getDataByKey('comment_id'));
    }
}
