<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\CommentRepositoryInterface;
use Amasty\Blog\Api\Data\CommentInterface;
use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\Customer\Api\CustomerRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php');
Resolver::getInstance()->requireDataFixture('Magento/Customer/_files/new_customer.php');

$objectManager = Bootstrap::getObjectManager();

/** @var CommentRepositoryInterface $commentRepository */
$commentRepository = $objectManager->create(CommentRepositoryInterface::class);

/** @var PostRepositoryInterface $postRepository */
$postRepository = $objectManager->create(PostRepositoryInterface::class);

/** @var CustomerRepositoryInterface $customerRepository */
$customerRepository = $objectManager->create(CustomerRepositoryInterface::class);

$customerId = $customerRepository->get('new_customer@example.com')->getId();

$postOneId = $postRepository->getByUrlKey('post-test-one-graph-ql')->getPostId();
$postThreeId = $postRepository->getByUrlKey('post-test-three-graph-ql')->getPostId();

/** @var CommentInterface $commentOne */
$commentOne = $objectManager->create(CommentInterface::class);
$commentOne->setStoreId(1);
$commentOne->setPostId($postOneId);
$commentOne->setStatus(2);
$commentOne->setCustomerId($customerId);
$commentOne->setMessage('First Test Graph Message Comment Post One');
$commentOne->setName('John');
$commentOne->setEmail('new_customer@example.com');
$commentRepository->save($commentOne);

/** @var CommentInterface $commentTwo */
$commentTwo = $objectManager->create(CommentInterface::class);
$commentTwo->setStoreId(1);
$commentTwo->setPostId($postOneId);
$commentTwo->setStatus(1);
$commentTwo->setMessage('Second Test Graph Message Comment Post One');
$commentTwo->setName('Graph One');
$commentTwo->setEmail('graph_one@example.com');
$commentRepository->save($commentTwo);

/** @var CommentInterface $commentThree */
$commentThree = $objectManager->create(CommentInterface::class);
$commentThree->setStoreId(1);
$commentThree->setReplyTo($commentOne->getCommentId());
$commentThree->setPostId($postOneId);
$commentThree->setStatus(1);
$commentThree->setMessage('Reply Test Graph Message Comment Post One');
$commentThree->setName('Graph Reply');
$commentThree->setEmail('graph_reply@example.com');
$commentRepository->save($commentThree);

/** @var CommentInterface $commentFour */
$commentFour = $objectManager->create(CommentInterface::class);
$commentFour->setStoreId(1);
$commentFour->setPostId($postThreeId);
$commentFour->setStatus(2);
$commentFour->setMessage('Reply Test Graph Message Comment Post Three');
$commentFour->setName('Graph Two');
$commentFour->setEmail('graph_two@example.com');
$commentRepository->save($commentFour);
