<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\App\Area;
use Magento\TestFramework\App\State;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php');
Resolver::getInstance()->requireDataFixture('Magento/Multishipping/Fixtures/simple_product_10.php');
Resolver::getInstance()->requireDataFixture('Magento/Multishipping/Fixtures/simple_product_20.php');

$objectManager = Bootstrap::getObjectManager();

/** @var State $state */
$state = $objectManager->create(State::class);

/** @var PostRepositoryInterface $postRepository */
$postRepository = $objectManager->create(PostRepositoryInterface::class);

/** @var ProductRepositoryInterface $productRepository */
$productRepository = $objectManager->create(ProductRepositoryInterface::class);

$postOne = $postRepository->getByUrlKey('post-test-one-graph-ql');
$postTwo = $postRepository->getByUrlKey('post-test-three-graph-ql');

$productIdOne = $productRepository->get('simple_10')->getId();
$productIdTwo = $productRepository->get('simple_20')->getId();

$relatedProductsContainerOne = [
    [
        'amasty_blog_position' => '1',
        'entity_id' => $productIdOne
    ]
];

$relatedProductsContainerTwo = [
    [
        'amasty_blog_position' => '1',
        'entity_id' => $productIdTwo
    ],
    [
        'amasty_blog_position' => '2',
        'entity_id' => $productIdOne
    ]
];

$state->setAreaCode(Area::AREA_ADMINHTML);

$postOne->setRelatedProductsContainer($relatedProductsContainerOne);
$postRepository->save($postOne);

$postTwo->setRelatedProductsContainer($relatedProductsContainerTwo);
$postRepository->save($postTwo);
