<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\AuthorRepositoryInterface;
use Amasty\Blog\Api\CategoryRepositoryInterface;
use Amasty\Blog\Api\Data\PostInterface;
use Amasty\Blog\Api\PostRepositoryInterface;
use Amasty\Blog\Api\TagRepositoryInterface;
use Magento\Framework\App\Area;
use Magento\TestFramework\App\State;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\Workaround\Override\Fixture\Resolver;

Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/blog_authors.php');
Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/blog_category.php');
Resolver::getInstance()->requireDataFixture('Amasty_BlogGraphQl::Test/GraphQl/_files/blog_tags.php');

$objectManager = Bootstrap::getObjectManager();

/** @var State $state */
$state = $objectManager->create(State::class);

/** @var PostRepositoryInterface $postRepository */
$postRepository = $objectManager->create(PostRepositoryInterface::class);

/** @var AuthorRepositoryInterface $authorRepository */
$authorRepository = $objectManager->create(AuthorRepositoryInterface::class);

/** @var CategoryRepositoryInterface $categoryRepository */
$categoryRepository = $objectManager->create(CategoryRepositoryInterface::class);

/** @var TagRepositoryInterface $tagRepository */
$tagRepository = $objectManager->create(TagRepositoryInterface::class);

$authorOne = $authorRepository->getByUrlKey('author-graph-name-one');
$authorTwo = $authorRepository->getByUrlKey('author-graph-name-two');

$categoryOne = $categoryRepository->getByUrlKey('cat-graph-ql');
$categoryTwo = $categoryRepository->getByUrlKey('cat-ch-t-graph-ql');

$tagOne = $tagRepository->getByUrlKey('tag-graph-one');
$tagTwo = $tagRepository->getByUrlKey('tag-graph-two');

$state->setAreaCode(Area::AREA_ADMINHTML);

/** @var PostInterface $postOne */
$postOne = $objectManager->create(PostInterface::class);
$postOne->setCanonicalUrl('https://amasty.com/');
$postOne->setListThumbnailAlt('thumb_test_alt');
$postOne->setPostThumbnailAlt('thumb_post_test_alt');
$postOne->setStatus('2');
$postOne->setAuthorId($authorOne->getAuthorId());
$postOne->setTitle('Post Test One GraphQl');
$postOne->setUrlKey('post-test-one-graph-ql');
$postOne->setShortContent('Short Test One GraphQl Content');
$postOne->setFullContent('Full Test One GraphQl Content');
$postOne->setDisplayShortContent(1);
$postOne->setStoreId(0);
$postOne->setMetaTitle('Meta Graph One Title');
$postOne->setMetaTags('Meta Graph One Tag');
$postOne->setMetaDescription('Meta Graph One Description');
$postOne->setMetaRobots('index, follow');
$postOne->setCommentsEnabled(1);
$postOne->setCategories([(string)$categoryOne->getCategoryId()]);
$postOne->setTags((string)$tagOne->getName());
$postRepository->save($postOne);

/** @var PostInterface $postTwo */
$postTwo = $objectManager->create(PostInterface::class);
$postTwo->setCanonicalUrl('https://amasty.com/');
$postTwo->setListThumbnail('amasty.png');
$postTwo->setListThumbnailAlt('thumb_test_alt');
$postTwo->setPostThumbnailAlt('amasty.png');
$postTwo->setPostThumbnailAlt('thumb_post_test_alt');
$postTwo->setStatus('2');
$postTwo->setAuthorId($authorTwo->getAuthorId());
$postTwo->setTitle('Post Test Two GraphQl');
$postTwo->setUrlKey('post-test-two-graph-ql');
$postTwo->setShortContent('Short Test Two GraphQl Content');
$postTwo->setFullContent('Full Test Two GraphQl Content');
$postTwo->setDisplayShortContent(1);
$postTwo->setStoreId(0);
$postTwo->setMetaTitle('Meta Graph Two Title');
$postTwo->setMetaTags('Meta Graph Two Tag');
$postTwo->setMetaDescription('Meta Graph Two Description');
$postTwo->setMetaRobots('index, follow');
$postTwo->setRelatedPostIds((string)$postOne->getPostId());
$postTwo->setIsFeatured(1);
$postTwo->setCategories([(string)$categoryTwo->getCategoryId()]);
$postTwo->setTags((string)$tagTwo->getName());
$postRepository->save($postTwo);

/** @var PostInterface $postThree */
$postThree = $objectManager->create(PostInterface::class);
$postThree->setCanonicalUrl('https://amasty.com/');
$postThree->setListThumbnail('amasty.png');
$postThree->setListThumbnailAlt('thumb_test_alt');
$postThree->setPostThumbnailAlt('amasty.png');
$postThree->setPostThumbnailAlt('thumb_post_test_alt');
$postThree->setStatus('2');
$postThree->setAuthorId($authorTwo->getAuthorId());
$postThree->setTitle('Post Test Three GraphQl');
$postThree->setUrlKey('post-test-three-graph-ql');
$postThree->setShortContent('Short Test Three GraphQl Content');
$postThree->setFullContent('Full Test Three GraphQl Content');
$postThree->setDisplayShortContent(0);
$postThree->setStoreId(0);
$postThree->setMetaTitle('Meta Graph Three Title');
$postThree->setMetaTags('Meta Graph Three Tag');
$postThree->setMetaDescription('Meta Graph Three Description');
$postThree->setMetaRobots('index, follow');
$postThree->setCommentsEnabled(1);
$postThree->setIsFeatured(1);
$postThree->setCategories([(string)$categoryOne->getCategoryId()]);
$postThree->setTags($tagOne->getName() . ',' . $tagTwo->getName());
$postRepository->save($postThree);
