<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\TagRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var TagRepositoryInterface $tagRepository */
$tagRepository = $objectManager->create(TagRepositoryInterface::class);

$tagsUrls = ['tag-graph-one', 'tag-graph-two'];

$tags = $tagRepository->getAllTags();

foreach ($tags as $tag) {
    if (in_array($tag->getDataByKey('url_key'), $tagsUrls)) {
        $tagRepository->deleteById((int)$tag->getDataByKey('tag_id'));
    }
}
