<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\TagRepositoryInterface;
use Amasty\Blog\Api\Data\TagInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var TagRepositoryInterface $tagRepository */
$tagRepository = $objectManager->create(TagRepositoryInterface::class);

/** @var TagInterface $tagOne */
$tagOne = $objectManager->create(TagInterface::class);
$tagOne->setName('Tag Graph One')
    ->setUrlKey('tag-graph-one')
    ->setStoreId(0)
    ->setMetaTitle('Tag Meta Title Graph One')
    ->setMetaDescription('Tag Meta Description Graph One')
    ->setMetaTags('Tag Meta Tag Graph One')
    ->setMetaRobots('index, follow');
$tagRepository->save($tagOne);

/** @var TagInterface $tagTwo */
$tagTwo = $objectManager->create(TagInterface::class);
$tagTwo->setName('Tag Graph Two')
    ->setUrlKey('tag-graph-two')
    ->setStoreId(0)
    ->setMetaTitle('Tag Meta Title Graph Two')
    ->setMetaDescription('Tag Meta Description Graph Two')
    ->setMetaTags('Tag Meta Tag Graph Two')
    ->setMetaRobots('index, follow');
$tagRepository->save($tagTwo);
