<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\CategoryRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var CategoryRepositoryInterface $categoryRepository */
$categoryRepository = $objectManager->create(CategoryRepositoryInterface::class);

$categoryUrls = ['cat-graph-ql', 'cat-ch-o-graph-ql', 'cat-ch-t-graph-ql'];

$categories = $categoryRepository->getAllCategories();

foreach ($categories as $category) {
    if (in_array($category->getDataByKey('url_key'), $categoryUrls)) {
        $categoryRepository->deleteById((int)$category->getDataByKey('category_id'));
    }
}
