<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\CategoryRepositoryInterface;
use Amasty\Blog\Api\Data\CategoryInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var CategoryRepositoryInterface $categoryRepository */
$categoryRepository = $objectManager->create(CategoryRepositoryInterface::class);

/** @var CategoryInterface $category */
$category = $objectManager->create(CategoryInterface::class);
$category->setStatus(1)
    ->setStoreId(0)
    ->setName('Cat Graph Ql')
    ->setUrlKey('cat-graph-ql')
    ->setSortOrder(0)
    ->setParentId(0)
    ->setPath('0')
    ->setLevel(1)
    ->setMetaTitle('Cat Meta Title')
    ->setMetaDescription('Cat Meta Description')
    ->setMetaTags('Cat Meta Tag')
    ->setMetaRobots('index, follow');
$categoryRepository->save($category);

/** @var CategoryInterface $categoryChildOne */
$categoryChildOne = $objectManager->create(CategoryInterface::class);
$categoryChildOne->setStatus(1)
    ->setStoreId(0)
    ->setName('Cat Child One Graph Ql')
    ->setUrlKey('cat-ch-o-graph-ql')
    ->setSortOrder(0)
    ->setParentId($category->getCategoryId())
    ->setPath((string)$category->getCategoryId())
    ->setLevel(2)
    ->setMetaTitle('Cat Child One Meta Title')
    ->setMetaDescription('Cat Child One Meta Description')
    ->setMetaTags('Cat Child One Meta Tag')
    ->setMetaRobots('index, follow');
$categoryRepository->save($categoryChildOne);

/** @var CategoryInterface $categoryChildTwo */
$categoryChildTwo = $objectManager->create(CategoryInterface::class);
$categoryChildTwo->setStatus(1)
    ->setStoreId(0)
    ->setName('Cat Child Two Graph Ql')
    ->setUrlKey('cat-ch-t-graph-ql')
    ->setSortOrder(0)
    ->setParentId($category->getCategoryId())
    ->setPath((string)$category->getCategoryId())
    ->setLevel(2)
    ->setMetaTitle('Cat Child Meta Title')
    ->setMetaDescription('Cat Child Meta Description')
    ->setMetaTags('Cat Child Meta Tag')
    ->setMetaRobots('index, follow');
$categoryRepository->save($categoryChildTwo);
