<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\AuthorRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var AuthorRepositoryInterface $authorRepository */
$authorRepository = $objectManager->create(AuthorRepositoryInterface::class);

$authorsUrls = ['author-graph-name-one', 'author-graph-name-two'];

$authors = $authorRepository->getAuthorCollection()->getItems();

foreach ($authors as $author) {
    if (in_array($author->getDataByKey('url_key'), $authorsUrls)) {
        $authorRepository->deleteById((int)$author->getDataByKey('author_id'));
    }
}
