<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

use Amasty\Blog\Api\AuthorRepositoryInterface;
use Amasty\Blog\Api\Data\AuthorInterface;
use Magento\TestFramework\Helper\Bootstrap;

$objectManager = Bootstrap::getObjectManager();

/** @var AuthorRepositoryInterface $categoryRepository */
$categoryRepository = $objectManager->create(AuthorRepositoryInterface::class);

/** @var AuthorInterface $authorOne */
$authorOne = $objectManager->create(AuthorInterface::class);
$authorOne->setName('Author Graph Name One');
$authorOne->setUrlKey('author-graph-name-one');
$authorOne->setStoreId(0);
$authorOne->setMetaTags('Meta-title-graph-author-one');
$authorOne->setMetaDescription('Meta Description Graph Author One');
$authorOne->setMetaTitle('Meta Title Graph Author One');
$authorOne->setInstagramProfile('https://amasty.com/instagram');
$authorOne->setYoutubeProfile('https://amasty.com/youtube');
$authorOne->setLinkedinProfile('https://amasty.com/linkedin');
$authorOne->setFacebookProfile('https://amasty.com/facebook');
$authorOne->setTwitterProfile('https://amasty.com/twitter');
$authorOne->setTiktokProfile('https://amasty.com/tiktok');
$authorOne->setMetaRobots('index, follow');
$categoryRepository->save($authorOne);

/** @var AuthorInterface $authorTwo */
$authorTwo = $objectManager->create(AuthorInterface::class);
$authorTwo->setName('Author Graph Name Two');
$authorTwo->setUrlKey('author-graph-name-two');
$authorTwo->setStoreId(0);
$authorTwo->setMetaRobots('index, follow');
$authorTwo->setMetaTags('Meta-title-graph-author-two');
$authorTwo->setMetaDescription('Meta Description Graph Author Two');
$authorTwo->setMetaTitle('Meta Title Graph Author Two');
$authorTwo->setInstagramProfile('https://amasty.com/instagram');
$authorTwo->setYoutubeProfile('https://amasty.com/youtube');
$authorTwo->setLinkedinProfile('https://amasty.com/linkedin');
$authorTwo->setFacebookProfile('https://amasty.com/facebook');
$authorTwo->setTwitterProfile('https://amasty.com/twitter');
$authorTwo->setTiktokProfile('https://amasty.com/tiktok');
$categoryRepository->save($authorTwo);
