<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Magento\Widget\Model\ResourceModel\Widget\Instance\CollectionFactory;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogTagsWidgetTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogTagsWidget';

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->collectionFactory = $objectManager->get(CollectionFactory::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/widgets/tags_widget.php
     */
    public function testAmBlogTagsWidgetBase(): void
    {
        $result = false;
        $widgetId = (int)$this->collectionFactory->create()
            ->addFieldToFilter('title', 'Test Tags Widget Title')
            ->getFirstItem()->getId();

        $query = $this->getQuery($widgetId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertEquals('Test Tags Widget Title', $response[self::MAIN_QUERY_KEY]['title']);
        $this->assertGreaterThanOrEqual(2, count($response[self::MAIN_QUERY_KEY]['items']));

        foreach ($response[self::MAIN_QUERY_KEY]['items'] as $item) {
            if ($item['name'] == 'Tag Graph Two' && $item['url_key'] == 'tag-graph-two') {
                $result = true;
            }
        }

        $this->assertTrue($result, 'Not returns all items.');
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $widgetId): string
    {
        return <<<QUERY
query {
    amBlogTagsWidget(id: $widgetId) {
        items {
            name
            url_key
        }
        title
    }
}
QUERY;
    }
}
