<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\PostRepositoryInterface;
use Amasty\Blog\Api\TagRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogTagsTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogTags';

    /**
     * @var PostRepositoryInterface
     */
    private $postRepository;

    /**
     * @var TagRepositoryInterface
     */
    private $tagRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->postRepository = $objectManager->create(PostRepositoryInterface::class);
        $this->tagRepository = $objectManager->create(TagRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php
     */
    public function testAmBlogTagsBase(): void
    {
        $postThreeUrlKey = 'post-test-three-graph-ql';
        $postThreeId = $this->postRepository->getByUrlKey($postThreeUrlKey)->getPostId();

        $tagOneUrl = 'tag-graph-one';
        $tagTwoUrl = 'tag-graph-two';
        $tagIdOne = $this->tagRepository->getByUrlKey($tagOneUrl)->getTagId();
        $tagIdTwo = $this->tagRepository->getByUrlKey($tagTwoUrl)->getTagId();

        $fieldsResponseTagOne = [
            "meta_description" => "Tag Meta Description Graph One",
            "meta_robots" => "index, follow",
            "meta_tags" => "Tag Meta Tag Graph One",
            "meta_title" => "Tag Meta Title Graph One",
            "name" => "Tag Graph One",
            "tag_id" => $tagIdOne,
            "url_key" => $tagOneUrl
        ];
        $fieldsResponseTagTwo = [
            "meta_description" => "Tag Meta Description Graph Two",
            "meta_robots" => "index, follow",
            "meta_tags" => "Tag Meta Tag Graph Two",
            "meta_title" => "Tag Meta Title Graph Two",
            "name" => "Tag Graph Two",
            "tag_id" => $tagIdTwo,
            "url_key" => $tagTwoUrl
        ];

        $query = $this->getQuery($postThreeId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertEquals(2, count($response[self::MAIN_QUERY_KEY]['items']));
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['items'][0], $fieldsResponseTagOne);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['items'][1], $fieldsResponseTagTwo);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $postId): string
    {
        return <<<QUERY
query {
    amBlogTags(postId: $postId) {
        items {
            meta_description
            meta_robots
            meta_tags
            meta_title
            name
            tag_id
            url_key
        }
    }
}
QUERY;
    }
}
