<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogSettingTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogSetting';

    /**
     * @group amasty_blog
     *
     * @magentoConfigFixture amblog/comments/ask_name 0
     * @magentoConfigFixture amblog/post/image_height 112
     * @magentoConfigFixture amblog/recent_posts/image_width 277
     * @magentoConfigFixture amblog/display_settings/display_at_category 1
     * @magentoConfigFixture amblog/search_engine/bread Bread
     */
    public function testAmBlogSettingBase(): void
    {
        $buttons = [
            "twitter",
            "facebook",
            "vkontakte",
            "blogger",
            "pinterest",
            "tumblr",
            "digg",
            "slashdot",
            "reddit",
            "linkedin",
            "whatsapp"
        ];
        $text = "I agree to the <a href=\"/privacy-policy\" target=\"_blank\">Privacy Policy</a>";
        $query = $this->getQuery();
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertEquals(false, $response[self::MAIN_QUERY_KEY]['comments_ask_name']);
        $this->assertEquals(112, $response[self::MAIN_QUERY_KEY]['post_image_height']);
        $this->assertEquals(277, $response[self::MAIN_QUERY_KEY]['recent_posts_image_width']);
        $this->assertEquals(true, $response[self::MAIN_QUERY_KEY]['display_settings_display_at_category']);
        $this->assertEquals("Bread", $response[self::MAIN_QUERY_KEY]['search_engine_bread']);
        $this->assertEquals($buttons, $response[self::MAIN_QUERY_KEY]['social_buttons']);
        $this->assertEquals($text, $response[self::MAIN_QUERY_KEY]['comments_gdpr_text']);
        $this->assertJson($response[self::MAIN_QUERY_KEY]['layout_desktop_post']);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(): string
    {
        return <<<QUERY
{
  amBlogSetting {
    comments_allow_guests
    comments_ask_email
    comments_ask_name
    comments_autoapprove
    comments_display_date
    comments_display_short
    comments_gdpr
    comments_gdpr_text
    comments_record_limit
    comments_use_comments
    display_settings_display_at_category
    display_settings_display_at_footer
    display_settings_display_at_toolbar
    display_settings_label
    is_show_related_posts_on_product_page
    is_show_related_products_on_post_page
    layout_desktop_list
    layout_desktop_post
    layout_mobile_list
    layout_mobile_post
    list_count_per_page
    post_categories_limit
    post_date_manner
    post_display_author
    post_display_categories
    post_display_tags
    post_helpful
    post_image_height
    post_image_width
    post_related_products_block_title
    product_related_posts_tab_title
    recent_posts_display_date
    recent_posts_display_image
    recent_posts_display_short
    recent_posts_image_height
    recent_posts_image_width
    recent_posts_record_limit
    recent_posts_short_limit
    search_engine_bread
    search_engine_meta_description
    search_engine_meta_keywords
    search_engine_meta_robots
    search_engine_meta_title
    search_engine_organization_name
    search_engine_route
    search_engine_title
    search_engine_title_suffix
    social_buttons
    social_enabled
    tags_minimal_post_count
  }
}
QUERY;
    }
}
