<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogRelatedPostsTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogRelatedPosts';

    /**
     * @var PostRepositoryInterface
     */
    private $postRepository;

    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->postRepository = $objectManager->create(PostRepositoryInterface::class);
        $this->productRepository = $objectManager->create(ProductRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts_add_products.php
     */
    public function testAmBlogRelatedPostsBase(): void
    {
        $productId = (int)$this->productRepository->get('simple_10')->getId();

        $postOneUrlKey = 'post-test-one-graph-ql';
        $postThreeUrlKey = 'post-test-three-graph-ql';

        $postOneId = $this->postRepository->getByUrlKey($postOneUrlKey)->getPostId();
        $postThreeId = $this->postRepository->getByUrlKey($postThreeUrlKey)->getPostId();

        $fieldsItemsResponse = [
            [
                'post_id' => $postOneId,
                'url_key' => $postOneUrlKey
            ],
            [
                'post_id' => $postThreeId,
                'url_key' => $postThreeUrlKey
            ]
        ];

        $query = $this->getQuery($productId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertArrayHasKey('all_post_size', $response[self::MAIN_QUERY_KEY]);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['items'], $fieldsItemsResponse);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $productId): string
    {
        return <<<QUERY
query {
    amBlogRelatedPosts(productId: $productId) {
        all_post_size
        items {
            post_id
            url_key
        }
    }
}
QUERY;
    }
}
