<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Magento\Widget\Model\ResourceModel\Widget\Instance\CollectionFactory;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogRecentCommentsWidgetTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogRecentCommentsWidget';

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->collectionFactory = $objectManager->get(CollectionFactory::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts_comments.php
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/widgets/recent_comments_widget.php
     */
    public function testAmBlogRecentCommentsWidgetBase(): void
    {
        $result = false;
        $widgetId = (int)$this->collectionFactory->create()
            ->addFieldToFilter('title', 'Test Recent Comments Widget Title')
            ->getFirstItem()->getId();

        $query = $this->getQuery($widgetId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertEquals('100001', $response[self::MAIN_QUERY_KEY]['comments_limit']);
        $this->assertEquals('passed', $response[self::MAIN_QUERY_KEY]['date_manner']);
        $this->assertEquals('1', $response[self::MAIN_QUERY_KEY]['display_date']);
        $this->assertEquals('Header Text Recent Comments Test Graph', $response[self::MAIN_QUERY_KEY]['header_text']);
        $this->assertEquals('Test Recent Comments Widget Title', $response[self::MAIN_QUERY_KEY]['title']);
        $this->assertGreaterThanOrEqual(2, count($response[self::MAIN_QUERY_KEY]['items']));

        foreach ($response[self::MAIN_QUERY_KEY]['items'] as $item) {
            if ($item['email'] == 'graph_two@example.com' && $item['name'] == 'Graph Two') {
                $result = true;
            }
        }

        $this->assertTrue($result, 'Not returns all items.');
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $widgetId): string
    {
        return <<<QUERY
query {
    amBlogRecentCommentsWidget(id: $widgetId) {
        comments_limit
        date_manner
        display_date
        header_text
        items {
            email
            name
        }
        title
    }
}
QUERY;
    }
}
