<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogPostsTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogPosts';

    /**
     * @var PostRepositoryInterface
     */
    private $postRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->postRepository = $objectManager->create(PostRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php
     */
    public function testAmBlogPostsBase(): void
    {
        $result = false;
        $postThreeUrlKey = 'post-test-three-graph-ql';
        $postThreeId = $this->postRepository->getByUrlKey($postThreeUrlKey)->getPostId();

        $query = $this->getQueryAllPosts(1, 1);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertArrayHasKey('all_post_size', $response[self::MAIN_QUERY_KEY]);
        $this->assertGreaterThanOrEqual(3, count($response[self::MAIN_QUERY_KEY]['items']));

        foreach ($response[self::MAIN_QUERY_KEY]['items'] as $item) {
            if ($item['url_key'] == $postThreeUrlKey && $item['post_id'] == $postThreeId) {
                $result = true;
            }
        }

        $this->assertTrue($result, 'Not returns all items.');
    }

    /**
     * Returns GraphQl query string
     */
    private function getQueryAllPosts(int $page, int $entityId): string
    {
        return <<<QUERY
query {
  amBlogPosts(type: ALL, page: $page, entityId: $entityId) {
    all_post_size
    items {
      post_id
      url_key
    }
  }
}
QUERY;
    }
}
