<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogPostsSearchTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogPostsSearch';

    /**
     * @var PostRepositoryInterface
     */
    private $postRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->postRepository = $objectManager->create(PostRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php
     */
    public function testAmBlogPostsSearchBase(): void
    {
        $postTwoUrlKey = 'post-test-two-graph-ql';
        $postThreeUrlKey = 'post-test-three-graph-ql';

        $postTwoId = $this->postRepository->getByUrlKey($postTwoUrlKey)->getPostId();
        $postThreeId = $this->postRepository->getByUrlKey($postThreeUrlKey)->getPostId();

        $fieldsResponse = [
            [
                "post_id" => $postTwoId,
                "url_key" => $postTwoUrlKey
            ],
            [
                "post_id" => $postThreeId,
                "url_key" => $postThreeUrlKey
            ]
        ];

        $page = 1;
        $search = 'Post Test T';

        $query = $this->getQuery($page, $search);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertArrayHasKey('all_post_size', $response[self::MAIN_QUERY_KEY]);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['items'], $fieldsResponse);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $page, string $search): string
    {
        return <<<QUERY
query {
    amBlogPostsSearch(page: $page, query: "$search") {
        all_post_size
        items {
            post_id
            url_key
        }
    }
}
QUERY;
    }
}
