<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\AuthorRepositoryInterface;
use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogPostsByIdsTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogPostsByIds';

    /**
     * @var PostRepositoryInterface
     */
    private $postRepository;

    /**
     * @var AuthorRepositoryInterface
     */
    private $authorRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->postRepository = $objectManager->create(PostRepositoryInterface::class);
        $this->authorRepository = $objectManager->create(AuthorRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php
     */
    public function testAmBlogPostsByIdsBase(): void
    {
        $postOneUrlKey = 'post-test-one-graph-ql';
        $postTwoUrlKey = 'post-test-two-graph-ql';

        $postOneId = $this->postRepository->getByUrlKey($postOneUrlKey)->getPostId();
        $postTwoId = $this->postRepository->getByUrlKey($postTwoUrlKey)->getPostId();
        $authorOneId = (string)$this->authorRepository->getByUrlKey('author-graph-name-one')->getAuthorId();
        $authorTwoId = (string)$this->authorRepository->getByUrlKey('author-graph-name-two')->getAuthorId();

        $fieldsResponse = [
            [
                "author_id"=> $authorOneId,
                "post_id" => $postOneId,
                "url_key" => $postOneUrlKey
            ],
            [
                "author_id" => $authorTwoId,
                "post_id" => $postTwoId,
                "url_key" => $postTwoUrlKey
            ]
        ];

        $query = $this->getQuery($postOneId, $postTwoId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertArrayHasKey('all_post_size', $response[self::MAIN_QUERY_KEY]);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['items'], $fieldsResponse);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $idOne, int $idTwo): string
    {
        return <<<QUERY
query {
    amBlogPostsByIds(ids:[$idOne, $idTwo]) {
        all_post_size
        items {
            author_id
            post_id
            url_key
        }
    }
}
QUERY;
    }
}
