<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\CategoryRepositoryInterface;
use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogPostsByCategoryIdTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogPostsByCategoryId';

    /**
     * @var PostRepositoryInterface
     */
    private $postRepository;

    /**
     * @var CategoryRepositoryInterface
     */
    private $categoryRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->postRepository = $objectManager->create(PostRepositoryInterface::class);
        $this->categoryRepository = $objectManager->create(CategoryRepositoryInterface::class);

        $this->markTestSkipped("Query bug PDT-12938");
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php
     */
    public function testAmBlogPostsByCategoryIdBase(): void
    {
        $postOneUrlKey = 'post-test-one-graph-ql';
        $postThreeUrlKey = 'post-test-three-graph-ql';

        $postOneId = $this->postRepository->getByUrlKey($postOneUrlKey)->getPostId();
        $postThreeId = $this->postRepository->getByUrlKey($postThreeUrlKey)->getPostId();
        $categoryId = $this->categoryRepository->getByUrlKey('cat-graph-ql')->getCategoryId();

        $fieldsResponse = [
            [
                "post_id" => $postOneId,
                "url_key" => $postOneUrlKey
            ],
            [
                "post_id" => $postThreeId,
                "url_key" => $postThreeUrlKey
            ]
        ];

        $query = $this->getQuery($categoryId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertArrayHasKey('all_post_size', $response[self::MAIN_QUERY_KEY]);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['items'], $fieldsResponse);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $categoryId): string
    {
        return <<<QUERY
query {
    amBlogPostsByCategoryId(categoryId: $categoryId) {
        all_post_size
        items {
            post_id
            url_key
        }
    }
}
QUERY;
    }
}
