<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogPostRelatedProductsTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogPostRelatedProducts';

    /**
     * @var PostRepositoryInterface
     */
    private $postRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->postRepository = $objectManager->create(PostRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts_add_products.php
     */
    public function testAmBlogPostRelatedProductsBase(): void
    {
        $productOneSku = 'simple_10';
        $productTwoSku = 'simple_20';
        $postThreeId = $this->postRepository->getByUrlKey('post-test-three-graph-ql')->getPostId();

        $fieldsItemsResponse = [
            [
                'name' => 'Simple Product 20',
                'sku' => $productTwoSku
            ],
            [
                'name' => 'Simple Product 10',
                'sku' => $productOneSku
            ]
        ];

        $query = $this->getQuery($postThreeId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['items'], $fieldsItemsResponse);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $postId): string
    {
        return <<<QUERY
query {
    amBlogPostRelatedProducts(postId: $postId) {
        items {
            name
            sku
        }
    }
}
QUERY;
    }
}
