<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\PostRepositoryInterface;
use Magento\Widget\Model\ResourceModel\Widget\Instance\CollectionFactory;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogFeaturedPostsWidgetTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogFeaturedPostsWidget';

    /**
     * @var PostRepositoryInterface
     */
    private $postRepository;

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->postRepository = $objectManager->create(PostRepositoryInterface::class);
        $this->collectionFactory = $objectManager->get(CollectionFactory::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/widgets/featured_widget.php
     */
    public function testAmBlogFeaturedPostsWidgetBase(): void
    {
        $result = false;
        $postThreeUrlKey = 'post-test-three-graph-ql';
        $postThreeId = $this->postRepository->getByUrlKey($postThreeUrlKey)->getPostId();
        $widgetId = (int)$this->collectionFactory->create()
            ->addFieldToFilter('title', 'Test Featured Widget Title')
            ->getFirstItem()->getId();

        $query = $this->getQuery($widgetId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertEquals('Test Featured Widget Title', $response[self::MAIN_QUERY_KEY]['title']);
        $this->assertGreaterThanOrEqual(2, count($response[self::MAIN_QUERY_KEY]['items']));

        foreach ($response[self::MAIN_QUERY_KEY]['items'] as $item) {
            if ($item['url_key'] == $postThreeUrlKey && $item['post_id'] == $postThreeId) {
                $result = true;
            }
        }

        $this->assertTrue($result, 'Not returns all items.');
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $widgetId): string
    {
        return <<<QUERY
query {
    amBlogFeaturedPostsWidget(id: $widgetId) {
        items {
            post_id
            url_key
        }
        title
    }
}
QUERY;
    }
}
