<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\CategoryRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogChildCategoriesTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogChildCategories';

    /**
     * @var CategoryRepositoryInterface
     */
    private $categoryRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->categoryRepository = $objectManager->create(CategoryRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/blog_category.php
     */
    public function testAmBlogChildCategoriesBase(): void
    {
        $categoryUrl = 'cat-graph-ql';
        $categoryChildOneUrl = 'cat-ch-o-graph-ql';
        $categoryChildTwoUrl = 'cat-ch-t-graph-ql';
        $categoryId = $this->categoryRepository->getByUrlKey($categoryUrl)->getCategoryId();
        $categoryChildOneId = $this->categoryRepository->getByUrlKey($categoryChildOneUrl)->getCategoryId();
        $categoryChildTwoId = $this->categoryRepository->getByUrlKey($categoryChildTwoUrl)->getCategoryId();

        $fieldsResponseChildOne = [
            "category_id" => $categoryChildOneId,
            "name" => "Cat Child One Graph Ql",
            "parent_id" => $categoryId,
            "url_key" => $categoryChildOneUrl
        ];
        $fieldsResponseChildTwo = [
            "category_id" => $categoryChildTwoId,
            "name" => "Cat Child Two Graph Ql",
            "parent_id" => $categoryId,
            "url_key" => $categoryChildTwoUrl
        ];

        $query = $this->getQuery($categoryId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertEquals(2, count($response[self::MAIN_QUERY_KEY]['items']));
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['items'][0], $fieldsResponseChildOne);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY]['items'][1], $fieldsResponseChildTwo);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $categoryId): string
    {
        return <<<QUERY
query {
    amBlogChildCategories(id: $categoryId) {
        items {
            category_id
            name
            parent_id
            url_key
        }
    }
}
QUERY;
    }
}
