<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\CategoryRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogCategoryTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogCategory';

    /**
     * @var CategoryRepositoryInterface
     */
    private $categoryRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->categoryRepository = $objectManager->create(CategoryRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php
     */
    public function testAmBlogCategoryBase(): void
    {
        $categoryUrl = 'cat-graph-ql';
        $categoryId = $this->categoryRepository->getByUrlKey($categoryUrl)->getCategoryId();

        $fieldsResponse = [
            "category_id" => $categoryId,
            "level" => "1",
            "meta_description" => "Cat Meta Description",
            "meta_robots" => "index, follow",
            "meta_tags" => "Cat Meta Tag",
            "meta_title" => "Cat Meta Title",
            "name" => "Cat Graph Ql",
            "parent_id" => "0",
            "path" => "0",
            "post_count" => 2,
            "sort_order" => "0",
            "status" => "1",
            "store_id" => "0",
            "url_key" => $categoryUrl
        ];

        $query = $this->getQuery($categoryId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertArrayHasKey('relative_url', $response[self::MAIN_QUERY_KEY]);
        $this->assertArrayHasKey('type', $response[self::MAIN_QUERY_KEY]);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY], $fieldsResponse);
        $this->assertStringContainsString(date("Y-m-d"), $response[self::MAIN_QUERY_KEY]['created_at']);
        $this->assertStringContainsString(date("Y-m-d"), $response[self::MAIN_QUERY_KEY]['updated_at']);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $categoryId): string
    {
        return <<<QUERY
query {
    amBlogCategory(id: $categoryId) {
        category_id
        created_at
        level
        meta_description
        meta_robots
        meta_tags
        meta_title
        name
        parent_id
        path
        post_count
        relative_url
        sort_order
        status
        store_id
        type
        updated_at
        url_key
    }
}
QUERY;
    }
}
