<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Magento\Widget\Model\ResourceModel\Widget\Instance\CollectionFactory;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogCategoriesWidgetTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogCategoriesWidget';

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->collectionFactory = $objectManager->get(CollectionFactory::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/blog_category.php
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/widgets/categories_widget.php
     */
    public function testAmBlogCategoriesWidgetBase(): void
    {
        $widgetId = (int)$this->collectionFactory->create()
            ->addFieldToFilter('title', 'Test Categories Widget Title')
            ->getFirstItem()->getId();

        $fields = [
            'categories_limit' => '100001',
            'header_text' => 'Header Text Categories Test Graph',
            'title' => 'Test Categories Widget Title'
        ];

        $query = $this->getQuery($widgetId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY], $fields);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $widgetId): string
    {
        return <<<QUERY
query {
    amBlogCategoriesWidget(id: $widgetId) {
        categories_limit
        header_text
        title
    }
}
QUERY;
    }
}
