<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\CategoryRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogCategoriesTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogCategories';

    /**
     * @var CategoryRepositoryInterface
     */
    private $categoryRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->categoryRepository = $objectManager->create(CategoryRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/posts.php
     */
    public function testAmBlogCategoriesBase(): void
    {
        $result = false;
        $categoryUrl = 'cat-ch-t-graph-ql';
        $categoryParentUrl = 'cat-graph-ql';
        $categoryId = $this->categoryRepository->getByUrlKey($categoryUrl)->getCategoryId();
        $categoryParentId = $this->categoryRepository->getByUrlKey($categoryParentUrl)->getCategoryId();

        $fieldsResponse = [
            "category_id" => $categoryId,
            "level" => "2",
            "meta_description" => "Cat Child Meta Description",
            "meta_robots" => "index, follow",
            "meta_tags" => "Cat Child Meta Tag",
            "meta_title" => "Cat Child Meta Title",
            "name" => "Cat Child Two Graph Ql",
            "parent_id" => $categoryParentId,
            "path" => $categoryParentId,
            "post_count" => 1,
            "sort_order" => "0",
            "status" => "1",
            "store_id" => "0",
            "url_key" => $categoryUrl
        ];

        $query = $this->getQuery();
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertGreaterThanOrEqual(3, count($response[self::MAIN_QUERY_KEY]['items']));

        foreach ($response[self::MAIN_QUERY_KEY]['items'] as $item) {
            if ($item['category_id'] == $categoryId) {
                $this->assertArrayHasKey('relative_url', $item);
                $this->assertArrayHasKey('type', $item);
                $this->assertResponseFields($item, $fieldsResponse);
                $this->assertStringContainsString(date("Y-m-d"), $item['created_at']);
                $this->assertStringContainsString(date("Y-m-d"), $item['updated_at']);

                $result = true;
            }
        }

        $this->assertTrue($result);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(): string
    {
        return <<<QUERY
query {
    amBlogCategories {
        items {
            category_id
            created_at
            level
            meta_description
            meta_robots
            meta_tags
            meta_title
            name
            parent_id
            path
            post_count
            relative_url
            sort_order
            status
            store_id
            type
            updated_at
            url_key
        }
    }
}
QUERY;
    }
}
