<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\AuthorRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogAuthorsTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogAuthors';

    /**
     * @var AuthorRepositoryInterface
     */
    private $authorRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->authorRepository = $objectManager->create(AuthorRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/blog_authors.php
     */
    public function testAmBlogAuthorsBase(): void
    {
        $result = false;
        $authorUrlKey = 'author-graph-name-two';
        $authorId = $this->authorRepository->getByUrlKey($authorUrlKey)->getAuthorId();

        $fieldsResponse = [
            "name" => "Author Graph Name Two",
            "url_key" => $authorUrlKey,
        ];

        $query = $this->getQuery();
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertGreaterThanOrEqual(2, count($response[self::MAIN_QUERY_KEY]['items']));

        foreach ($response[self::MAIN_QUERY_KEY]['items'] as $item) {
            if ($item['author_id'] == $authorId) {
                $this->assertResponseFields($item, $fieldsResponse);

                $result = true;
            }
        }

        $this->assertTrue($result);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(): string
    {
        return <<<QUERY
query {
    amBlogAuthors {
        items {
            author_id
            name
            url_key
        }
    }
}
QUERY;
    }
}
