<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Test\GraphQl;

use Amasty\Blog\Api\AuthorRepositoryInterface;
use Magento\TestFramework\Helper\Bootstrap;
use Magento\TestFramework\TestCase\GraphQlAbstract;

class AmBlogAuthorTest extends GraphQlAbstract
{
    public const MAIN_QUERY_KEY = 'amBlogAuthor';

    /**
     * @var AuthorRepositoryInterface
     */
    private $authorRepository;

    protected function setUp(): void
    {
        $objectManager = Bootstrap::getObjectManager();
        $this->authorRepository = $objectManager->create(AuthorRepositoryInterface::class);
    }

    /**
     * @group amasty_blog
     *
     * @magentoApiDataFixture Amasty_BlogGraphQl::Test/GraphQl/_files/blog_authors.php
     */
    public function testAmBlogAuthorBase(): void
    {
        $authorUrlKey = 'author-graph-name-two';
        $authorId = $this->authorRepository->getByUrlKey($authorUrlKey)->getAuthorId();

        $fieldsResponse = [
            "author_id" => $authorId,
            "facebook_profile" => "https://amasty.com/facebook",
            "instagram_profile" => "https://amasty.com/instagram",
            "linkedin_profile" => "https://amasty.com/linkedin",
            "meta_description" => "Meta Description Graph Author Two",
            "meta_robots" => "index, follow",
            "meta_tags" => "Meta-title-graph-author-two",
            "meta_title" => "Meta Title Graph Author Two",
            "name" => "Author Graph Name Two",
            "tiktok_profile" => "https://amasty.com/tiktok",
            "twitter_profile" => "https://amasty.com/twitter",
            "url_key" => $authorUrlKey,
            "youtube_profile" => "https://amasty.com/youtube"
        ];

        $query = $this->getQuery($authorId);
        $response = $this->graphQlQuery($query);

        $this->assertArrayHasKey(self::MAIN_QUERY_KEY, $response);
        $this->assertResponseFields($response[self::MAIN_QUERY_KEY], $fieldsResponse);
    }

    /**
     * Returns GraphQl query string
     */
    private function getQuery(int $authorId): string
    {
        return <<<QUERY
query {
    amBlogAuthor(id: $authorId) {
        author_id
        facebook_profile
        instagram_profile
        linkedin_profile
        meta_description
        meta_robots
        meta_tags
        meta_title
        name
        tiktok_profile
        twitter_profile
        url_key
        youtube_profile
    }
}

QUERY;
    }
}
