<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Plugin\UrlRewriteGraphQl\Model\Resolver\Route;

use Amasty\BlogGraphQl\Model\Resolver\BlogEntityUrl;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\UrlRewriteGraphQl\Model\Resolver\Route;

class ResolveBlogRoute
{
    /**
     * @var BlogEntityUrl
     */
    private $blogEntityUrl;

    public function __construct(
        BlogEntityUrl $blogEntityUrl
    ) {
        $this->blogEntityUrl = $blogEntityUrl;
    }

    /**
     * @param Route $subject
     * @param array|null $result
     * @param Field $field
     * @param $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array|null
     * @throws \Exception
     */
    public function afterResolve(
        Route $subject,
        ?array $result,
        Field $field,
        $context,
        ResolveInfo $info,
        ?array $value,
        ?array $args
    ): ?array {
        return $result ?? $this->blogEntityUrl->resolve($field, $context, $info, $value, $args);
    }
}
