<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver\Widget;

use Amasty\Blog\Block\Tags;
use Amasty\Blog\Model\ResourceModel\Tag\Collection as TagCollection;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Widget\Model\ResourceModel\Widget\Instance\Collection;

class Tag extends AbstractWidget implements ResolverInterface
{
    /**
     * @var Tags
     */
    private $tagBlock;

    public function __construct(
        Collection $widgetCollection,
        Tags $tagBlock
    ) {
        parent::__construct($widgetCollection);
        $this->tagBlock = $tagBlock;
    }

    protected function getItemCollection(array $data, $storeId = 0): TagCollection
    {
        $this->tagBlock->setData($data);

        return $this->tagBlock->getCollection($storeId);
    }

    protected function generateDataFromBlock(): array
    {
        return [];
    }
}
