<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver\Widget;

use Magento\Framework\GraphQl\Query\ResolverInterface;

class RecentPost extends AbstractWidget implements ResolverInterface
{
    /**
     * @var \Amasty\Blog\Block\Sidebar\Recentpost
     */
    private $recentPost;

    /**
     * @var \Amasty\Blog\Helper\Settings
     */
    private $helperSettings;

    public function __construct(
        \Magento\Widget\Model\ResourceModel\Widget\Instance\Collection $widgetCollection,
        \Amasty\Blog\Block\Sidebar\Recentpost $recentPost,
        \Amasty\Blog\Helper\Settings $helperSettings
    ) {
        parent::__construct($widgetCollection);
        $this->recentPost = $recentPost;
        $this->helperSettings = $helperSettings;
    }

    /**
     * @param array $data
     * @param int $storeId
     * @return \Amasty\Blog\Model\ResourceModel\Posts\Collection|mixed
     */
    protected function getItemCollection(array $data, $storeId = 0)
    {
        $this->recentPost->setData($data);
        return $this->recentPost->getCollection();
    }

    /**
     * @param array $data
     * @param $context
     * @return array
     */
    protected function convertData(array $data, $context)
    {
        $data['amasty_widget_categories'] = implode(', ', $data['amasty_widget_categories'] ?? []);
        $data['amasty_widget_tags'] = implode(', ', $data['amasty_widget_tags'] ?? []);

        foreach ($data['items'] as &$item) {
            $item = $this->convertPostItem($item, $context);
        }

        return $data;
    }

    /**
     * @return array
     */
    protected function generateDataFromBlock()
    {
        return [
            'header_text' => $this->recentPost->getBlockHeader(),
            'posts_limit' => $this->helperSettings->getRecentPostsLimit(),
            'show_images' => $this->recentPost->showImages(),
            'display_date' => $this->recentPost->needShowDate(),
            'date_manner' => $this->helperSettings->getDateFormat(),
            'display_short' => $this->recentPost->needShowThesis(),
            'short_limit' => $this->helperSettings->getRecentPostsShortLimit()
        ];
    }
}
