<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver\Widget;

use Magento\Framework\GraphQl\Query\ResolverInterface;

class RecentComment extends AbstractWidget implements ResolverInterface
{
    /**
     * @var \Amasty\Blog\Api\CommentRepositoryInterface
     */
    private $commentRepository;

    /**
     * @var \Amasty\Blog\Block\Sidebar\Recentcomments
     */
    private $commentsBlock;

    /**
     * @var \Amasty\Blog\Helper\Settings
     */
    private $helperSettings;

    /**
     * @var \Amasty\Blog\Api\PostRepositoryInterface
     */
    private $postRepository;

    public function __construct(
        \Magento\Widget\Model\ResourceModel\Widget\Instance\Collection $widgetCollection,
        \Amasty\Blog\Api\CommentRepositoryInterface $commentRepository,
        \Amasty\Blog\Block\Sidebar\Recentcomments $commentsBlock,
        \Amasty\Blog\Helper\Settings $helperSettings,
        \Amasty\Blog\Api\PostRepositoryInterface $postRepository
    ) {
        parent::__construct($widgetCollection);
        $this->commentRepository = $commentRepository;
        $this->commentsBlock = $commentsBlock;
        $this->helperSettings = $helperSettings;
        $this->postRepository = $postRepository;
    }

    /**
     * @param array $data
     * @param $context
     * @return array
     */
    protected function convertData(array $data, $context)
    {
        foreach ($data['items'] as &$item) {
            $post = $this->postRepository->getById((int)($item['post_id']));
            $item['post'] = $post->getData();
        }

        return $data;
    }

    /**
     * @param array $data
     * @param int $storeId
     * @return \Amasty\Blog\Model\ResourceModel\Tag\Collection|mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function getItemCollection(array $data, $storeId = 0)
    {
        $commentsCollection = $this->commentRepository->getRecentComments();
        return $commentsCollection->setPageSize($data['comments_limit']);
    }

    /**
     * @return array
     */
    protected function generateDataFromBlock()
    {
        return [
            'header_text' => $this->commentsBlock->getBlockHeader(),
            'comments_limit' => $this->commentsBlock->getCommentsLimit(),
            'display_date' => $this->commentsBlock->needShowDate(),
            'date_manner' => $this->helperSettings->getDateFormat()
        ];
    }
}
