<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver\Widget;

use Magento\Framework\GraphQl\Query\ResolverInterface;

class FeaturedPost extends AbstractWidget implements ResolverInterface
{
    /**
     * @var \Amasty\Blog\Block\Featured
     */
    private $featured;

    public function __construct(
        \Magento\Widget\Model\ResourceModel\Widget\Instance\Collection $widgetCollection,
        \Amasty\Blog\Block\Featured $featured
    ) {
        parent::__construct($widgetCollection);
        $this->featured = $featured;
    }

    /**
     * @param array $data
     * @param int $storeId
     * @return \Amasty\Blog\Model\ResourceModel\Tag\Collection|mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function getItemCollection(array $data, $storeId = 0)
    {
        $this->featured->setData($data);
        return $this->featured->getCollection();
    }

    /**
     * @param array $data
     * @param $context
     * @return array
     */
    protected function convertData(array $data, $context)
    {
        foreach ($data['items'] as &$item) {
            $item = $this->convertPostItem($item, $context);
        }

        return $data;
    }

    /**
     * @return array
     */
    protected function generateDataFromBlock()
    {
        return [];
    }
}
