<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver\Widget;

use Magento\Framework\GraphQl\Query\ResolverInterface;

class Category extends AbstractWidget implements ResolverInterface
{
    /**
     * @var \Amasty\Blog\Api\CategoryRepositoryInterface
     */
    private $categoryRepository;

    /**
     * @var \Amasty\Blog\Block\Sidebar\Category
     */
    private $categoryBlock;

    public function __construct(
        \Magento\Widget\Model\ResourceModel\Widget\Instance\Collection $widgetCollection,
        \Amasty\Blog\Api\CategoryRepositoryInterface $categoryRepository,
        \Amasty\Blog\Block\Sidebar\Category $categoryBlock
    ) {
        parent::__construct($widgetCollection);
        $this->categoryRepository = $categoryRepository;
        $this->categoryBlock = $categoryBlock;
    }

    /**
     * @param array $data
     * @param int $storeId
     * @return \Amasty\Blog\Model\ResourceModel\Categories\Collection|mixed
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    protected function getItemCollection(array $data, $storeId = 0)
    {
        return [];
    }

    /**
     * @return array
     */
    protected function generateDataFromBlock()
    {
        return [
            'header_text' => $this->categoryBlock->getBlockHeader(),
            'categories_limit' => $this->categoryBlock->getCategoriesLimit()
        ];
    }
}
