<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver\UrlRewrite\TypeResolver;

use Magento\Framework\GraphQl\Query\Resolver\TypeResolverInterface;

class Category implements TypeResolverInterface
{
    public const AMBLOG_CATEGORY = 'AMBLOG_CATEGORY';
    public const TYPE_RESOLVER = 'AmBlogCategory';

    public function resolveType(array $data): string
    {
        if (isset($data['type_id']) && $data['type_id'] === self::AMBLOG_CATEGORY) {
            return self::TYPE_RESOLVER;
        }

        return '';
    }
}
