<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver\UrlRewrite;

use Amasty\BlogGraphQl\Model\Resolver\Post as PostResolver;
use Amasty\BlogGraphQl\Model\Resolver\UrlRewrite\TypeResolver\Post as PostTypeResolver;
use Amasty\BlogGraphQl\Model\UrlRewrite\UrlKeyMatcher;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\Resolver\Value;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class Post implements ResolverInterface
{
    private const NO_REDIRECT = 0;

    /**
     * @var PostResolver
     */
    private $postEntityResolver;

    /**
     * @var UrlKeyMatcher
     */
    private $urlKeyMatcher;

    public function __construct(
        UrlKeyMatcher $urlKeyMatcher,
        PostResolver $postEntityResolver
    ) {
        $this->postEntityResolver = $postEntityResolver;
        $this->urlKeyMatcher = $urlKeyMatcher;
    }

    /**
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array|Value|mixed
     * @throws GraphQlNoSuchEntityException
     */
    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $urlKey = $this->urlKeyMatcher->match($args['url'] ?? '');

        if ($urlKey === null) {
            return null;
        }

        $args['urlKey'] = $urlKey;
        $result = $this->postEntityResolver->resolve($field, $context, $info, $value, $args);

        if (!is_array($result) || !isset($result['post_id'])) {
            throw new GraphQlNoSuchEntityException(__('Post doesn\'t exist'));
        }

        $result[QueryParamInterface::TYPE] = PostTypeResolver::AMBLOG_POST;
        $result[QueryParamInterface::TYPE_ID] = PostTypeResolver::AMBLOG_POST;
        $result[QueryParamInterface::REDIRECT_CODE] = self::NO_REDIRECT;
        $result[QueryParamInterface::RELATIVE_URL] = $args['url'];

        return $result;
    }
}
