<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver;

use Amasty\Blog\Helper\Data;
use Amasty\Blog\Helper\Settings;
use Amasty\Blog\Model\ConfigProvider;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Store\Model\StoreManagerInterface;

class Setting implements ResolverInterface
{
    /**
     * @var Settings
     */
    private $settings;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var Data
     */
    private $helperData;

    public function __construct(
        Settings $settings,
        ConfigProvider $configProvider,
        StoreManagerInterface $storeManager,
        Data $helperData
    ) {
        $this->settings = $settings;
        $this->storeManager = $storeManager;
        $this->configProvider = $configProvider;
        $this->helperData = $helperData;
    }

    /**
     * @param Field $field
     * @param \Magento\Framework\GraphQl\Query\Resolver\ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array|\Magento\Framework\GraphQl\Query\Resolver\Value|mixed
     * @throws \Exception
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $storeId = (int)$context->getExtensionAttributes()->getStore()->getId();
        $this->storeManager->setCurrentStore($storeId);

        return $this->getData();
    }

    /**
     * @return array
     */
    private function getData()
    {
        return [
            'display_settings_label' => $this->settings->getBlogLabel(),
            'display_settings_display_at_footer' => $this->settings->isDisplayAtFooter(),
            'display_settings_display_at_toolbar' => $this->settings->isDisplayAtToolbar(),
            'display_settings_display_at_category' => $this->settings->isDisplayAtCategoryMenu(),
            'search_engine_bread' => $this->settings->getBreadcrumb(),
            'search_engine_route' => $this->settings->getSeoRoute(),
            'search_engine_title' => $this->settings->getSeoTitle(),
            'search_engine_title_suffix' => $this->settings->getModuleConfig('search_engine/title_suffix'),
            'search_engine_meta_title' => $this->settings->getBlogMetaTitle(),
            'search_engine_meta_description' => $this->settings->getBlogMetaDescription(),
            'search_engine_meta_keywords' => $this->settings->getBlogMetaKeywords(),
            'search_engine_meta_robots' => $this->settings->getBlogMetaRobots(),
            'search_engine_organization_name' => $this->settings->getModuleConfig('search_engine/organization_name'),
            'layout_mobile_list' => $this->settings->getMobileList(),
            'layout_mobile_post' => $this->settings->getMobilePost(),
            'layout_desktop_list' => $this->settings->getDesktopList(),
            'layout_desktop_post' => $this->settings->getDesktopPost(),
            'list_count_per_page' => $this->settings->getPostsLimit(),
            'post_display_author' => $this->settings->getShowAuthor(),
            'post_display_categories' => $this->settings->getUseCategories(),
            'post_categories_limit' => $this->settings->getCategoriesLimit(),
            'post_display_tags' => $this->settings->getUseTags(),
            'post_date_manner' => $this->settings->getDateFormat(),
            'post_image_width' => $this->settings->getImageWidth(),
            'post_image_height' => $this->settings->getImageHeight(),
            'post_helpful' => $this->settings->getHelpfulEnabled(),
            'comments_use_comments' => $this->settings->getUseComments(),
            'comments_autoapprove' => $this->settings->getCommentsAutoapprove(),
            'comments_allow_guests' => $this->settings->getCommentsAllowGuests(),
            'comments_record_limit' => $this->settings->getCommentsLimit(),
            'comments_display_short' => $this->settings->getRecentCommentsDisplayShort(),
            'comments_display_date' => $this->settings->getRecentCommentsDisplayDate(),
            'comments_ask_email' => $this->configProvider->isAskEmail(),
            'comments_ask_name' => $this->configProvider->isAskName(),
            'comments_gdpr' => $this->configProvider->isShowGdpr(),
            'comments_gdpr_text' => $this->configProvider->getGdprText(),
            'recent_posts_record_limit' => $this->settings->getRecentPostsLimit(),
            'recent_posts_display_short' => $this->settings->getRecentPostsDisplayShort(),
            'recent_posts_short_limit' => $this->settings->getRecentPostsShortLimit(),
            'recent_posts_display_date' => $this->settings->getRecentPostsDisplayDate(),
            'recent_posts_display_image' => $this->settings->isRecentPostsUseImage(),
            'recent_posts_image_width' => $this->settings->getRecentPostsImageWidth(),
            'recent_posts_image_height' => $this->settings->getRecentPostsImageHeight(),
            'tags_minimal_post_count' => $this->settings->getTagsMinimalPostCount(),
            'social_enabled' => $this->settings->getSocialEnabled(),
            'social_buttons' => $this->helperData->getSocialNetworks(),
            'is_show_related_posts_on_product_page' => $this->configProvider->isShowPostPageBlockOnProductPage(),
            'is_show_related_products_on_post_page' => $this->configProvider->isShowPostPageBlockOnPostPage(),
            'product_related_posts_tab_title' => $this->configProvider->getPostPageBlockTitleOnProductPage(),
            'post_related_products_block_title' => $this->configProvider->getPostPageBlockTitleOnPostPage(),
        ];
    }
}
