<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver;

use Amasty\Blog\Api\CommentRepositoryInterface;
use Amasty\Blog\Api\Data\GetRelatedPostsForProductInterface;
use Amasty\Blog\Api\Data\PostInterface;
use Amasty\Blog\Api\PostRepositoryInterface;
use Amasty\Blog\Api\ViewRepositoryInterface;
use Amasty\Blog\Helper\Settings;
use Amasty\Blog\Model\ResourceModel\Vote\CollectionFactory as VoteCollectionFactory;
use Amasty\Blog\ViewModel\ContentPreparation\Preparers\ProcessWysiwygContent;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Psr\Log\LoggerInterface;

class ProductRelatedPosts extends Post implements ResolverInterface
{
    /**
     * @var ProcessWysiwygContent
     */
    protected $processWysiwygContent;

    /**
     * @var GetRelatedPostsForProductInterface
     */
    private $getRelatedPostsForProduct;

    public function __construct(
        ProcessWysiwygContent $processWysiwygContent,
        PostRepositoryInterface $postRepository,
        ViewRepositoryInterface $viewRepository,
        CommentRepositoryInterface $commentRepository,
        LoggerInterface $logger,
        Settings $settings,
        GetRelatedPostsForProductInterface $getRelatedPostsForProduct,
        VoteCollectionFactory $voteCollectionFactory
    ) {
        $this->processWysiwygContent = $processWysiwygContent;
        $this->getRelatedPostsForProduct = $getRelatedPostsForProduct;

        parent::__construct(
            $processWysiwygContent,
            $postRepository,
            $viewRepository,
            $commentRepository,
            $logger,
            $settings,
            $voteCollectionFactory
        );
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $posts = [];

        if (isset($args['productId'])) {
            $posts = $this->getRelatedPostsForProduct->execute($args['productId']);
            $posts = array_map(function (PostInterface $post) use ($context): array {
                return $this->convertData($post, $context);
            }, $posts);
        }

        return [
            'items' => $posts
        ];
    }
}
