<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver;

use Amasty\Blog\Api\Data\AuthorInterface;
use Amasty\Blog\Api\Data\PostInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class PostsByIds extends Post implements ResolverInterface
{
    /**
     * @param Field $field
     * @param \Magento\Framework\GraphQl\Query\Resolver\ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array|\Magento\Framework\GraphQl\Query\Resolver\Value|mixed
     * @throws \Exception
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $data = [];
        try {
            $posts = $this->getCollection()
                ->addFieldToFilter(PostInterface::POST_ID, $args['ids']);
        } catch (\Exception $e) {
            $this->logger->error($e->getMessage());
            return ['error' => __('Wrong data.')];
        }

        foreach ($posts as $post) {
            $data['items'][] = $this->convertData($post, $context);
        }

        return $data;
    }

    /**
     * @return \Amasty\Blog\Model\ResourceModel\Posts\Collection
     */
    protected function getCollection()
    {
        return $this->postRepository->getActivePosts()
            ->setUrlKeyIsNotNull()
            ->setDateOrder();
    }
}
