<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver;

use Amasty\Blog\Model\ResourceModel\Posts\Collection as PostsCollection;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class PostsByCategoryId extends Post implements ResolverInterface
{
    /**
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $data = [];
        $categoryId = $args['categoryId'] ?? null;

        if ($categoryId) {
            try {
                $posts = $this->getCollection((int)$categoryId);
            } catch (\Exception $e) {
                $this->logger->critical($e->getMessage());
                return ['error' => __('Wrong data.')];
            }

            foreach ($posts as $post) {
                $data['items'][] = $this->convertData($post, $context);
            }
        }

        return $data;
    }

    protected function getCollection(int $categoryId): PostsCollection
    {
        return $this->postRepository->getActivePosts()
            ->setUrlKeyIsNotNull()
            ->setDateOrder()
            ->addCategoryFilter($categoryId);
    }
}
