<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver;

use Amasty\Blog\Api\Data\AuthorInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class Posts extends Post implements ResolverInterface
{
    /**
     * @param Field $field
     * @param \Magento\Framework\GraphQl\Query\Resolver\ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return array|\Magento\Framework\GraphQl\Query\Resolver\Value|mixed
     * @throws \Exception
     */
    public function resolve(
        Field $field,
        $context,
        ResolveInfo $info,
        array $value = null,
        array $args = null
    ) {
        $data = [];
        try {
            $posts = $this->getCollection();
            $entityId = $args['entityId'] ?? 0;
            switch ($args['type']) {
                case 'CATEGORY':
                    $posts->addCategoryFilter($entityId);
                    break;
                case 'AUTHOR':
                    $posts->addFieldToFilter(AuthorInterface::AUTHOR_ID, $entityId);
                    break;
                case 'TAG':
                    $posts->addTagFilter($entityId);
                    break;
                default:
                    $posts = $this->postRepository->getRecentPosts();
            }

            $data['all_post_size'] = $posts->getSize();
            if (isset($args['page'])) {
                $posts->setPageSize($this->settings->getPostsLimit())->setCurPage($args['page']);
            }
        } catch (\Exception $e) {
            $this->logger->error($e->getMessage());
            return ['error' => __('Wrong data.')];
        }

        foreach ($posts as $post) {
            $data['items'][] = $this->convertData($post, $context);
        }

        return $data;
    }

    /**
     * @return \Amasty\Blog\Model\ResourceModel\Posts\Collection
     */
    protected function getCollection()
    {
        return $this->postRepository->getActivePosts()
            ->setUrlKeyIsNotNull()
            ->setDateOrder();
    }
}
