<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver;

use Amasty\Blog\Api\Data\GetPostRelatedProductsInterface;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;
use Magento\Review\Model\ReviewFactory;

class PostRelatedProducts implements ResolverInterface
{
    /**
     * @var GetPostRelatedProductsInterface
     */
    private $getPostRelatedProducts;

    /**
     * @var ReviewFactory
     */
    private $reviewFactory;

    public function __construct(
        GetPostRelatedProductsInterface $getPostRelatedProducts,
        ReviewFactory $reviewFactory
    ) {
        $this->getPostRelatedProducts = $getPostRelatedProducts;
        $this->reviewFactory = $reviewFactory;
    }

    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        $items = [];

        if (isset($args['postId'])) {
            foreach ($this->getPostRelatedProducts->execute($args['postId']) as $product) {
                $productData = $product->getData();
                $productData['model'] = $product;
                $productData['is_salable'] = (bool) $product->getIsSalable();
                $productData['rating_summary'] = (int) $this->getRating($product);
                $productData['reviews_count'] = (int) $product->getRatingSummary()->getReviewsCount();
                $items[$product->getId()] = $productData;
            }
        }

        return [
            'items' => $items
        ];
    }

    private function getRating(ProductInterface $product): string
    {
        $this->reviewFactory->create()->getEntitySummary($product);

        return $product->getRatingSummary() instanceof \Magento\Framework\DataObject
            ? (string)$product->getRatingSummary()->getRatingSummary()
            : (string)$product->getRatingSummary();
    }
}
