<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model\Resolver;

use Amasty\BlogGraphQl\Api\BlogEntityResolverPoolInterface;
use Magento\Framework\GraphQl\Config\Element\Field;
use Magento\Framework\GraphQl\Exception\GraphQlNoSuchEntityException;
use Magento\Framework\GraphQl\Query\Resolver\ContextInterface;
use Magento\Framework\GraphQl\Query\Resolver\Value;
use Magento\Framework\GraphQl\Query\ResolverInterface;
use Magento\Framework\GraphQl\Schema\Type\ResolveInfo;

class BlogEntityUrl implements BlogEntityResolverPoolInterface
{
    /**
     * @var ResolverInterface[]
     */
    private $entityResolvers;

    /**
     * @param ResolverInterface[] $entityResolvers
     */
    public function __construct(
        array $entityResolvers = []
    ) {
        $this->entityResolvers = $entityResolvers;
    }

    /**
     * @param Field $field
     * @param ContextInterface $context
     * @param ResolveInfo $info
     * @param array|null $value
     * @param array|null $args
     * @return Value|mixed|null
     * @throws \Exception
     */
    public function resolve(Field $field, $context, ResolveInfo $info, array $value = null, array $args = null)
    {
        foreach ($this->entityResolvers as $entityResolver) {
            try {
                $result = $entityResolver->resolve($field, $context, $info, $value, $args);

                if (!empty($result)) {
                    return $result;
                }
            } catch (GraphQlNoSuchEntityException $e) {
                // There is no such entity, continue searching for matching
                continue;
            }
        }

        return null;
    }
}
