<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Amasty Blog GraphQl for Magento 2 (System)
 */

namespace Amasty\BlogGraphQl\Model;

use Magento\Framework\GraphQl\Exception\GraphQlInputException;
use Magento\Framework\GraphQl\Query\Resolver\TypeResolverInterface;

class PostInterfaceTypeResolverComposite implements TypeResolverInterface
{
    /**
     * TypeResolverInterface[]
     */
    private $postTypeNameResolvers = [];

    /**
     * @param TypeResolverInterface[] $postTypeNameResolvers
     */
    public function __construct(array $postTypeNameResolvers = [])
    {
        $this->postTypeNameResolvers = $postTypeNameResolvers;
    }

    /**
     * {@inheritdoc}
     * @throws GraphQlInputException
     */
    public function resolveType(array $data) : string
    {
        throw new GraphQlInputException(
            __('Concrete type for %1 not implemented', ['PostInterface'])
        );
    }
}
