// Generated by CoffeeScript 1.8.0
define(['jquery', 'Amasty_Blog/js/vendor/swipe/jquery.touch_swipe.min'], function($){
    return $.fn.swipy = function(options) {
      var $config;
      $config = $.extend({
        side: "left",
        ignore: ".am-content.std p, .am-content.std table",
        enable_point: 770,
        button_selector: "[data-amblog-js='swipe-me']",
        button_close: "[data-amblog-js='close']",
        overlay_selector: "[data-amblog-js='overlay']"
      }, options);
      return this.each(function() {
        var $button, $document, $panel, $window, closePanel, disableSwipes, enableSwipes, onDocumentClick, onKeyUp, onPanelClick, onWindowResize, openPanel;
        $document = $(document);
        $window = $(window);
        $panel = $(this);
        $button = $($config.button_selector);
        $buttonClose = $($config.button_close);
        $overlay = $($config.overlay_selector);
        onWindowResize = function() {
          var height, width;
          height = $window.height();
          width = $window.width();
          if (width > $config.enable_point) {
            disableSwipes();
          } else {
            enableSwipes();
          }
          return $panel.css({
            height: '#{height}px'
          });
        };
        disableSwipes = function() {
          $($document).swipe('disable');
          $($panel).swipe('disable');
          return this;
        };
        enableSwipes = function() {
          $($document).swipe('enable');
          $($panel).swipe('enable');
          return this;
        };
        onDocumentClick = function(e) {
          return closePanel();
        };
        onPanelClick = function(e) {
          return e.stopPropagation();
        };
        onKeyUp = function(e) {
          if (e.keyCode === 27) {
            return closePanel();
          }
        };
        openPanel = function() {
          $panel.addClass('active');
          $document.on('keyup', onKeyUp);
          return setTimeout(function(e) {
            $panel.on('click', onPanelClick);
            return $document.on('click', onDocumentClick);
          }, 300);
        };
        closePanel = function() {
          $panel.removeClass('active');
          $document.off('keyup', onKeyUp);
          $document.off('click', onDocumentClick);
          return $panel.off('click', onPanelClick);
        };
        if ($config.side === 'right') {
          $($document).swipe({
            swipeLeft: function(event, direction, distance, duration, fingerCount) {
              return openPanel();
            },
            threshold: 100,
            maxTimeThreshold: 1500,
            excludedElements: $.fn.swipe.defaults.excludedElements + "," + $config.ignore
          });
          $($panel).swipe({
            swipeRight: function(event, direction, distance, duration, fingerCount) {
              return closePanel();
            },
            threshold: 80,
            maxTimeThreshold: 1500
          });
        } else {
          $($document).swipe({
            swipeRight: function(event, direction, distance, duration, fingerCount) {
              return openPanel();
            },
            threshold: 100,
            maxTimeThreshold: 1500,
            excludedElements: $.fn.swipe.defaults.excludedElements + "," + $config.ignore
          });
          $($panel).swipe({
            swipeLeft: function(event, direction, distance, duration, fingerCount) {
              return closePanel();
            },
            threshold: 80,
            maxTimeThreshold: 1500
          });
        }
        $button.click(function() {
          if ($panel.hasClass("active")) {
            closePanel();
          } else {
            openPanel();
            $overlay.css("display", "block")
          }
          return this;
        });
        $buttonClose.click(function() {
          closePanel();
          $overlay.css("display", "none")
        });
        $overlay.click(function() {
          closePanel();
          $overlay.css("display", "none")
        });
        onWindowResize();
        $window.on('resize', onWindowResize);
        return this;
      });
    };
});