// Generated by CoffeeScript 1.8.0

/*
 * Magpleasure Ltd.
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.magpleasure.com/LICENSE.txt
 *
 * @category   Magpleasure
 * @package    Magpleasure_Common
 * @copyright  Copyright (c) 2014 Magpleasure Ltd. (http://www.magpleasure.com)
 * @license    http://www.magpleasure.com/LICENSE.txt
 */
angular.module("com.magpleasure.file.upload", ["oi.file"]).directive("mpFileUpload", function() {
  return {
    restrict: "C",
    replace: true,
    templateUrl: 'magpleasure/file/upload.html',
    scope: {
      mpConfig: "="
    },
    controller: [
      "$scope", function($scope) {
        $scope.config = $scope.mpConfig;
        if ($scope.config.has_file) {
          $scope.file = {
            file_type: $scope.config.file_type,
            url: $scope.config.url,
            value: $scope.config.value
          };
          if ($scope.config.is_image) {
            $scope.file.thumbnail_url = $scope.config.thumbnail_url;
            $scope.file.is_image = true;
          }
        } else {
          $scope.file = {};
        }
        $scope["delete"] = [];
        $scope.options = {
          fieldName: $scope.config.html_id,
          change: function(file) {
            file.$upload($scope.config.upload_url, $scope.file);
          }
        };
        $scope.showProgress = function() {
          return !!$scope.file.uploading;
        };
        $scope.hasFile = function() {
          return !!$scope.file.value;
        };
        $scope.hasError = function() {
          return !!$scope.file.error;
        };
        $scope.getRequired = function() {
          return $scope.config.is_required && !$scope.file.has_thumbnail;
        };
        $scope.checkImageExistence = function() {
          return $($scope.config.html_id).disabled = $scope.config.has_thumbnail;
        };
        $scope.disableLoader = function() {
          $scope.loading = false;
          $scope.loading_percent = 0;
        };
        $scope.startLoader = function() {
          $scope.error_message = false;
          $scope.loading_percent = 0;
          $scope.loading = true;
        };
        $scope.clearData = function() {
          $scope["delete"].push($scope.value);
          $scope.value = '';
          $scope.file = {};
          $scope.checkImageExistence();
        };
      }
    ]
  };
});

Validation.add('required-file', 'This is a required field.', function(value, field) {
  return !Validation.get('IsEmpty') && field.hasClassName('field-ready');
});
