<?php
/**
 * @author Amasty Team
 * @copyright Copyright (c) 2023 Amasty (https://www.amasty.com)
 * @package AMP for Magento 2
 */

namespace Amasty\Amp\Block\Cms;

class Page extends \Magento\Cms\Block\Page
{
    /**
     * @return string
     */
    protected function _toHtml()
    {
        $actionName = $this->getRequest()->getFullActionName();
        if ($this->getData('configProvider')->isAmpEnabledOnCurrentPage($actionName)) {
            $ampContent = (string)$this->getPage()->getAmpContent();
            $content = preg_replace('/\s+/', ' ', trim($ampContent))
                ? $ampContent
                : $this->getPage()->getContent();
            $html = $this->getData('validator')
                ->getValidHtml($this->_filterProvider->getPageFilter()->filter($content));
        } else {
            $html = parent::_toHtml();
        }

        return $html;
    }
}
